system module _SystemDynamic

from StdOverloaded import class toString, class ==

// dynamics consist of a value with a type code
:: DynamicTemp	= E.a:
	{	_value	:: a
	,	_type	:: T_ypeObjectType
	}

// representation of type codes
:: TypeCode
	=	TypeScheme !Int TypeCode		// Int = # variables
	|	TypeVar !Int					// Int = variable number
	|	TypeCons !TypeCodeConstructor
	|	TypeApp !TypeCode !TypeCode
	|	_TypePatternVar !Int			// used internally between compiler and
										// unification algorithm
	|	_TypeEmpty						// used internally during unification

instance toString TypeCode
instance == TypeCode

// representation of type constructor codes
:: TypeCodeConstructor
instance toString TypeCodeConstructor
instance == TypeCodeConstructor
typeCodeOfDynamic :: !Dynamic -> TypeCode

// type code constructors for predefined types
TypeCodeConstructorInt :: TypeCodeConstructor
TypeCodeConstructorChar :: TypeCodeConstructor
TypeCodeConstructorReal :: TypeCodeConstructor
TypeCodeConstructorBool :: TypeCodeConstructor
TypeCodeConstructorDynamic :: TypeCodeConstructor
TypeCodeConstructorFile :: TypeCodeConstructor
TypeCodeConstructorWorld :: TypeCodeConstructor
TypeCodeConstructor_Arrow :: TypeCodeConstructor
TypeCodeConstructor_List :: TypeCodeConstructor
TypeCodeConstructor_StrictList :: TypeCodeConstructor
TypeCodeConstructor_UnboxedList :: TypeCodeConstructor
TypeCodeConstructor_TailStrictList :: TypeCodeConstructor
TypeCodeConstructor_StrictTailStrictList :: TypeCodeConstructor
TypeCodeConstructor_UnboxedTailStrictList :: TypeCodeConstructor
TypeCodeConstructor_Tuple :: !Int -> TypeCodeConstructor	// arity: 2 .. 32
TypeCodeConstructor_LazyArray :: TypeCodeConstructor
TypeCodeConstructor_StrictArray :: TypeCodeConstructor
TypeCodeConstructor_UnboxedArray :: TypeCodeConstructor

// unification functions

:: _UnificationEnvironment

_initial_unification_environment :: !Int !Int -> *_UnificationEnvironment
_bind_global_type_pattern_var :: !TypeCode !T_ypeObjectType !*_UnificationEnvironment -> *_UnificationEnvironment
// first type arg is the actual type, second is the type pattern
_unify :: !_UnificationEnvironment !T_ypeObjectType !TypeCode -> (!Bool, _UnificationEnvironment)
_normalise :: !Bool !_UnificationEnvironment !TypeCode -> T_ypeObjectType

// RWS ... remove when dynamic linker has been changed

:: T_ypeName	:== {#Char}

:: T_ypeID
	// internal dynamic
	= ModuleID DummyModuleID				// within application
	
	// external dynamic
	| RunTimeID !Int				// id (both encoded/decoded dynamic rts)
	| LazyRunTimeID !Int !Int 		// id {dynamic_index (both rt and disk)} {disk library instance w.r.t. main dynamic}

:: T_ypeObjectType
	= T_ypeConsSymbol !T_ypeName !T_ypeID [T_ypeObjectType]
	| PV_Placeholder (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType
	| UPV_Placeholder (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType
	| UV_Placeholder TypeCode // (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType

// ... RWS

// Dynamic Linker stuff follows

/* */

from StdFile import ::Files, class FileSystem
//from StdDynamicLowLevelInterface import ::RunTimeIDW
import StdDynamicLowLevelInterface
import StdDynamicTypes

import DynamicLinkerInterface

	
:: GlobalDynamicInfo = {
	// general
		file_name		:: !String
	,	first_time		:: !Bool

	// block table
	,	id				:: !Int				// id from Dynamic Linker
	,	block_table		:: !BlockTable		
	,	graph_blocks	:: !{String}		// filepointer to start of graph
	,	graph_pointers	:: !{#.{Int}}
	
	// 
	,	diskid_to_runtimeid	:: !{#Int}		// conversion from DiskId (disguished as RunTimeId) to *real* runtimeID (library instances)
	,	di_disk_to_rt_dynamic_indices	:: !{#Int} // conversion from disk to runtime index for lazy dynamics
	,	di_dummy		:: !String
	,	di_type_redirection_table		:: !{#RunTimeIDW}

	}
// The # above ensure that no ARRAY node is inserted.

// force compiler to pass entire records instead of all entries
:: GlobalDynamicInfoDummy = {
		gdid			:: !GlobalDynamicInfo
	}

// BuildBlock
:: Pointer

build_lazy_block :: !Int !Int -> a //Pointer;

build_block :: !Int !GlobalDynamicInfoDummy -> a //Pointer /* algemeen: een stuk graaf */

//build_block :: !Int !GlobalDynamicInfoDummy -> Pointer /* algemeen: een stuk graaf */
// John: Pointer should be changed in BuildBlockResult. I think it should left as it is
// because normally the user doesn't see this.

instance EncodedDynamic String



// -----------------------------------------------------------------
:: Wrap a 
	= { 
		wrap_info		:: !a
	};

// aanpassen van gesharde type door alle library instanties		
:: *CopyGraphToStringArguments
	= {
		cgtsa_dynamic					:: Dynamic
	,	cgtsa_code_library_instances	:: !*{#Int}
	,	cgtsa_type_library_instances	:: !*{#Int}
	,	cgtsa_range_table				:: !{#Char}
	};
		
:: *CopyGraphToStringResults
	= {
		cgtsr_encoded_dynamic			:: !*{#Char}
	,	cgtsr_code_library_instances	:: !*{#T_ypeConsSymbolInfo}		// unused
	,	cgtsr_type_library_instances	:: !*{#Int}
	,	cgtsr_lazy_dynamic_references	:: !{#LazyDynamicReference}
	,	cgtsr_runtime_ids				:: !{#RunTimeIDW}
	}
	
:: T_ypeConsSymbolInfo
	= {
		tcsi_type_and_module_name		:: !String
	,	tcsi_rt_library_instance		:: !Int
	}	
	
class EncodedDynamic a
where 
	dynamic_to_string :: !Dynamic -> (!Bool,!*a)

:: *EncodedDynamic
	= { 
		ed_encoded_graph	:: !*{#Char}
	,	ed_dynamic_rts_info	:: !*{#Char}
	}

instance EncodedDynamic EncodedDynamic

string_to_dynamic :: !String -> (!Bool,!Dynamic)


init_dynamic :: !String !DynamicHeader !*a -> *(.Bool,.GlobalDynamicInfoDummy,*a) | BinaryDynamicIO a
//build_dynamic :: !Int !GlobalDynamicInfoDummy -> a //Dynamic


// zooi
copy_graph_to_string_OK :: !(Wrap CopyGraphToStringArguments) -> (Wrap CopyGraphToStringResults);


/* */